<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('name', 'category_id', 'price', 'description', 'type', 'viewer', 'time', 'user_id');

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

    public function images()
    {
        return $this->hasMany('App\Models\Image');
    }

    public function additions()
    {
        return $this->belongsToMany('App\Models\Addition', 'addition_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function carts()
    {
        return $this->hasMany('App\Models\Cart');
    }

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order', 'order_id')->withPivot(['note','price','quantity']);
    }

}